/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.hmcservc;

import com.ibm.hwmca.base.hmcservc.HmcServicesErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;

public class HmcServicesBean
extends PanelBean
implements HmcServicesErrorIds {
    private static final String TRACE_MASKT = "HSRVBENT";
    private static final String TRACE_MASKF = "HSRVBENF";
    private static final String TRACE_MASKD = "HSRVBEND";
    public static final String ACTION = "action";
    public static final String COMMIT = "commit";
    public static final String BEAN = "bean";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-42, "HmcServcBean");
    private transient boolean changed;
    private boolean access;
    private boolean limitedAccess;
    private transient String remoteOperationChoice;
    private String remoteOperationId;
    private transient String opticalChoice;
    private String opticalId;
    private transient String callAnsChoice;
    private String callAnsId;
    private transient String licChangeChoice;
    private String licChangeId;
    private transient String cimManagementChoice;
    private String cimManagementId;

    public String getRemoteOperationChoice() {
        return this.remoteOperationChoice;
    }

    public void setRemoteOperationChoice(String s) {
        this.changed |= !s.equals(this.remoteOperationChoice);
        this.remoteOperationChoice = s;
    }

    public String getRemoteOperationId() {
        return this.remoteOperationId;
    }

    public void setRemoteOperationId(String s) {
        this.remoteOperationId = s;
    }

    public String getOpticalChoice() {
        return this.opticalChoice;
    }

    public void setOpticalChoice(String s) {
        this.changed |= !s.equals(this.opticalChoice);
        this.opticalChoice = s;
    }

    public String getOpticalId() {
        return this.opticalId;
    }

    public void setOpticalId(String s) {
        this.opticalId = s;
    }

    public String getCallAnsChoice() {
        return this.callAnsChoice;
    }

    public void setCallAnsChoice(String s) {
        this.changed |= !s.equals(this.callAnsChoice);
        this.callAnsChoice = s;
    }

    public String getCallAnsId() {
        return this.callAnsId;
    }

    public void setCallAnsId(String s) {
        this.callAnsId = s;
    }

    public String getLICChangeChoice() {
        return this.licChangeChoice;
    }

    public void setLICChangeChoice(String s) {
        this.changed |= !s.equals(this.licChangeChoice);
        this.licChangeChoice = s;
    }

    public String getLICChangeId() {
        return this.licChangeId;
    }

    public void setLICChangeId(String s) {
        this.licChangeId = s;
    }

    public String getCIMManagementChoice() {
        return this.cimManagementChoice;
    }

    public void setCIMManagementChoice(String s) {
        this.changed |= !s.equals(this.cimManagementChoice);
        this.cimManagementChoice = s;
    }

    public String getCIMManagementId() {
        return this.cimManagementId;
    }

    public void setCIMManagementId(String s) {
        this.cimManagementId = s;
    }

    public void setAccess(boolean b) {
        this.access = b;
    }

    public void setLimitedAccess(boolean b) {
        this.limitedAccess = b;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.setRemoteOperationChoice(this.userTaskManager.getValue(this.getMountPrefix() + this.remoteOperationId));
        this.setOpticalChoice(this.userTaskManager.getValue(this.getMountPrefix() + this.opticalId));
        this.setCallAnsChoice(this.userTaskManager.getValue(this.getMountPrefix() + this.callAnsId));
        this.setLICChangeChoice(this.userTaskManager.getValue(this.getMountPrefix() + this.licChangeId));
        this.setCIMManagementChoice(this.userTaskManager.getValue(this.getMountPrefix() + this.cimManagementId));
        if (!this.access) {
            this.userTaskManager.setShown(this.getMountPrefix().substring(0, this.getMountPrefix().length() - 1), false);
        }
        if (this.limitedAccess) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "RemoteOperationChoice", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "OpticalChoice", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "LICChangeChoice", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "CIMManagementChoice", false);
        }
        this.changed = false;
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void update(Object updateBean) {
        Trace.trace(TRACE_MASKT, "-> update(" + updateBean + ")");
        Trace.trace(TRACE_MASKT, "<- update()");
    }

    public void save() {
    }

    public void verifyChanges() {
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
        try {
            String element = event.getElementName();
            Trace.trace(TRACE_MASKT, "element = " + element);
            if (element.equals(this.getMountPrefix() + "OkButton")) {
                boolean usingSSL;
                this.userTaskManager.storeAllElements();
                String remoteOp = this.stripMountPrefix(this.userTaskManager.getSelectedElementNames(this.getMountPrefix() + "RemoteOperationChoice")[0]);
                this.setRemoteOperationId(remoteOp);
                if ("EnabledRemoteOperationItem".equals(remoteOp) && !(usingSSL = System.getProperty("USING_APACHE_SSL", "false").equalsIgnoreCase("true"))) {
                    CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText("Insecure Remote Operation"), new MessageText(null, "          <b>Insecure</b> remote operation will be enabled.\nTo enable <b>secure</b> remote operation use the \n\"Certificate Management\" task to create a self-signed certificate."), MsgType.INFORMATION_MESSAGE);
                }
                this.setOpticalId(this.stripMountPrefix(this.userTaskManager.getSelectedElementNames(this.getMountPrefix() + "OpticalChoice")[0]));
                this.setCallAnsId(this.stripMountPrefix(this.userTaskManager.getSelectedElementNames(this.getMountPrefix() + "CallAnsChoice")[0]));
                this.setLICChangeId(this.stripMountPrefix(this.userTaskManager.getSelectedElementNames(this.getMountPrefix() + "LICChangeChoice")[0]));
                this.setCIMManagementId(this.stripMountPrefix(this.userTaskManager.getSelectedElementNames(this.getMountPrefix() + "CIMManagementChoice")[0]));
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData(ACTION, COMMIT);
                request.setData(BEAN, this);
                this.postTaskletRequest(request);
            } else if (element.equals(this.getMountPrefix() + "CancelButton")) {
                boolean ans;
                this.userTaskManager.storeAllElements();
                if (this.changed && !(ans = CommonMsgApp.showDataChangedConfirmation(this.userTaskManager))) {
                    Trace.trace(TRACE_MASKF, "throw IllegalUserDataException <- panelAction()");
                    throw new IllegalUserDataException();
                }
                this.dispose();
            }
        }
        catch (IllegalUserDataException e) {
            throw e;
        }
        catch (Exception e) {
            new FrameworkLog(logInfo, 5, e).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    private String stripMountPrefix(String s) {
        Trace.trace(TRACE_MASKT, "-> stripMountPrefix(" + s + ")");
        String n = s.startsWith(this.getMountPrefix()) ? s.substring(this.getMountPrefix().length(), s.length()) : s;
        Trace.trace(TRACE_MASKT, n + " <- stripMountPrefix()");
        return n;
    }
}

